import pickle
import vtk
def write_blender(mol):
    name = mol.name
    writer = vtk.vtkPolyDataWriter()
    writer.SetFileName(name+"_tube")
    writer.SetInputConnection(mol.assembly.tuber.GetOutputPort())
    writer.Write()
    
    writer = vtk.vtkPolyDataWriter()
    writer.SetFileName(name+"_glyph")
    writer.SetInputConnection(mol.assembly.glyph.GetOutputPort())
    writer.Write()
    
    numColors = mol.assembly.lut.GetNumberOfColors()
    lut = []
    for i in range(numColors):
        lut.append(mol.assembly.lut.GetTableValue(i))
    output = open(name+'.pkl', 'wb')
    pickle.dump(lut, output)
    output.close()
    return lut