#$Id: utils.py 111 2011-07-11 19:58:30Z sarkiss $
"""util.py currently contains which() function used to show the full path of autodock.
"""
import os, sys, shutil
from mglutil.util.packageFilePath import getResourceFolder
from about import appName

def which (filename):
    """Source http://mail.python.org/pipermail/python-list/2002-August/157829.html"""
    if os.access(filename, os.X_OK):
            return filename    
    if not os.environ.has_key('PATH') or os.environ['PATH'] == '':
        p = os.defpath
    else:
        p = os.environ['PATH']

    pathlist = p.split (os.pathsep)
    pathlist.append(os.path.split(sys.executable)[0])
    
    for path in pathlist:
        f = os.path.join(path, filename)
        if os.access(f, os.X_OK):
            return f
    return None

def cpuCount():
    '''
    Returns the number of CPUs in the system
    '''
    num = 1
    if sys.platform == 'win32':
        try:
            num = int(os.environ['NUMBER_OF_PROCESSORS'])
        except (ValueError, KeyError):
            pass
    elif sys.platform == 'darwin':
        try:
            num = int(os.popen('sysctl -n hw.ncpu').read())
        except ValueError:
            pass
    else:
        try:
            num = os.sysconf('SC_NPROCESSORS_ONLN')
        except (ValueError, OSError, AttributeError):
            pass        
    return num       

rcFolder = getResourceFolder()
rcFolder = os.path.join(rcFolder, appName)
if not os.path.exists(rcFolder):
    os.mkdir(rcFolder)

rcFile = os.path.join(rcFolder, 'preferences.ini')
if not os.path.exists(rcFile):
    try:
        shutil.copy(os.path.join(os.path.split(__file__)[0], 'preferences.ini'), rcFile)
    except Exception, inst:
        print inst
        print "Please make sure that you have a write permission for "+rcFolder
        import tempfile
        rcFolder =tempfile.mkdtemp()
        rcFile = os.path.join(rcFolder, 'preferences.ini')
        shutil.copy(os.path.join(os.path.split(__file__)[0], 'preferences.ini'), rcFile) 
        
    txt = open(rcFile).read()
    txt = txt.replace("workspace = .", "workspace = "+rcFolder)
    if cpuCount()-1 > 0:
        txt = txt.replace("cpu_num = 1", "cpu_num = "+str(cpuCount()-1))
    if which('qsub'):
        txt = txt.replace("executionMode = 2", "executionMode = 1")
    vina = os.path.join(os.path.split(sys.executable)[0], 'vina')
    if sys.platform == 'win32':
        vina = vina+".exe"
    elif sys.platform == 'darwin':
        vina = "/Library/MGLTools/PyRx/bin/vina"        
    txt = txt.replace("= vina", "= "+vina)
    open(rcFile,'w').write(txt)
    
else:
    #adds  vina binary to previously installed preferences.ini (can be removed in future versions)
    txt = open(rcFile).read()
    if txt.find("workspace = .") == -1 and  txt.find("vina")  == -1:
        #this is where we modify preferences.ini from the previous installation 
        num = txt.find("cpu_num =")
        vina = os.path.join(os.path.split(sys.executable)[0], 'vina')
        if sys.platform == 'win32':
            vina = vina+".exe"
        elif sys.platform == 'darwin':
            vina = "/Library/MGLTools/PyRx/bin/vina"
        txt = txt[:num]+"vina = "+vina+"\n"+txt[num:]
        open(rcFile,'w').write(txt)

def RemoveDirs(path):
    """source http://docs.python.org/lib/os-file-dir.html
    Delete everything reachable from the directory named in 'top',
    assuming there are no symbolic links.
    CAUTION:  This is dangerous!  For example, if top == '/', it
    could delete all your disk files."""
    for root, dirs, files in os.walk(path, topdown=False):
        for name in files:
            try:
                os.remove(os.path.join(root, name))
            except OSError:
                pass
        for name in dirs:
            try:
                os.rmdir(os.path.join(root, name))
            except OSError:
                pass   
    try:
        os.removedirs(path) # added to remove path itself
        os.rmdir(path)
    except OSError:
        pass