#$Id: exportWizard.py 152 2013-10-14 23:57:28Z sarkiss $
import  wx
import  wx.wizard as wiz
import  wx.lib.filebrowsebutton as filebrowse
import os

class FirstPage(wiz.WizardPageSimple):
    def __init__(self, parent):
        wiz.WizardPageSimple.__init__(self, parent)
        sizer = wx.BoxSizer(wx.VERTICAL)
        self.SetSizer(sizer)
        title = wx.StaticText(self, -1, "Select Export Destination:")
        sizer.Add(title, 0, wx.ALIGN_LEFT|wx.ALL, 5)
        sizer.Add(wx.StaticLine(self, -1), 0, wx.EXPAND|wx.ALL, 5)
        from user import home
        dest = os.path.join(home,'PyRx_workspace.tar.gz')
        self.exportPathButton = filebrowse.FileBrowseButton(self, -1, size=(450, -1), labelText="", initialValue=dest)        
        sizer.Add(self.exportPathButton, 0)
        self.sizer = sizer
        
class ExportWizard:
    def __init__(self, parent):
        self.parent = parent
        
    def Start(self):        
        wizard = wiz.Wizard(self.parent, -1, "Export")
        page1 = FirstPage(wizard)
        self.page1 = page1
        txt = """This file is used to store contents of your workspace folder:\n\n   """+os.path.abspath(self.parent.vsModel.basePath)
        txt+= """\n\nThis folder contains all the files generated by PyRx. Please use\n
File > Import > Workspace Tarball to import these files back to PyRx."""
        page1.sizer.Add(wx.StaticText(page1, -1, txt))
        wizard.FitToPage(page1)
        wizard.GetPageAreaSizer().Add(page1)
        if wizard.RunWizard(page1):
            self.parent.SetAllCursors(wx.StockCursor(wx.CURSOR_WAIT))
            dlg = wx.ProgressDialog("Please Wait...",
                                   "Archiving Workspace Folder. Please Wait...",
                                   maximum = 100,
                                   parent=self.parent,
                                   style = wx.PD_CAN_ABORT
                                    | wx.PD_APP_MODAL
                                    | wx.PD_ELAPSED_TIME
                                    )         
            import tarfile
            path = page1.exportPathButton.GetValue()
            tar = tarfile.open(path, "w:gz")
            keepGoing = True
            tar.add(self.parent.vsModel.etcFolder,'etc')
            #(keepGoing, skip) = dlg.Update(20, "Archiving Workspace Ligands  Folder.  Please Wait..")
            if keepGoing:
                tar.add(self.parent.vsModel.ligandsFolder,'Ligands')
                #(keepGoing, skip) = dlg.Update(60, "Archiving Workspace Ligands  Folder.  Please Wait..")                
            if keepGoing:
                tar.add(self.parent.vsModel.macromoleculesFolder,'Macromolecules')
            tar.close()
            dlg.Destroy()
            self.parent.SetAllCursors(wx.NullCursor)     
            wx.MessageBox("Output path: "+path, "Export Completed Successfully.")
            
