import vtk, wx
from enthought import tvtk 
def show_h_bonds(frame, molecule1, molecule2):
    "This function is to show hydrogen bonds"
    hbondDict = frame.pmv.mv.buildHBonds(molecule1, molecule2)
    if not hbondDict:
        print molecule1.name, molecule2.name
        frame.statusBar.SetStatusText("No hydrogen bond found between %s and %s."%(molecule1.name, molecule2.name), 0)
        return
    
    hbondData = vtk.vtkAppendPolyData()
    for hydrogen in hbondDict:
        for item in hbondDict[hydrogen]:
            line=vtk.vtkLineSource()
            line.SetPoint1(hydrogen.coords)
            line.SetPoint2(item.coords)
            hbondData.AddInput(line.GetOutput())

    hbondsMapper = vtk.vtkPolyDataMapper()
    hbondsMapper.SetInput(hbondData.GetOutput())

    hbondsActor = vtk.vtkActor()
    hbondsActor.SetMapper(hbondsMapper)
    hbondsActor.GetProperty().SetColor(0,1,0)
    hbondsActor.GetProperty().SetLineStipplePattern(0xf0f0)
    hbondsActor.GetProperty().SetLineStippleRepeatFactor(1)
    hbondsActor.GetProperty().SetPointSize(1)
    hbondsActor.GetProperty().SetLineWidth(1.5)
    if molecule1 == molecule2:
        molecule1.allAtoms[0].assembly.AddPart(hbondsActor)    
        molecule1.hbondsActor = hbondsActor
    else:
        if not hasattr(frame, 'hbonds'):
            assembly = vtk.vtkAssembly()
            frame.renderer3D.AddActor(assembly)
            frame.hbonds = assembly
        frame.hbonds.AddPart(hbondsActor)
    
def toggle_hbonds(event):
    "This function is called from the toolbar to toggle hydrogen bonds"
    frame = wx.GetTopLevelWindows()[0]
    molecules = frame.molecules
    if len(molecules) == 0:
        dlg = wx.MessageDialog(frame, 'This tool requires at least one molecule to work with.',
                               'Please Read a Molecule First', wx.OK | wx.ICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()        
        event.EventObject.ToggleTool(event.Id, 0)
    elif len(molecules) == 1:
        if event.Checked():
            show_h_bonds(frame, molecules[0], molecules[0])
        else:
            molecules[0].hbondsActor.SetVisibility(False)
            frame.mayaviEngine.scene.render()
    else:
        if event.Checked():
            for i, molecule1 in enumerate(molecules):
                 for molecule2 in  molecules[i+1:]:
                     show_h_bonds(frame, molecule1, molecule2)
            frame.mayaviEngine.scene.render()
        else:
            frame.renderer3D.RemoveActor(frame.hbonds)
            del frame.hbonds 
            frame.mayaviEngine.scene.render()
    