#$Id: testAutoDockWizard.py 255 2015-10-12 00:52:28Z sarkiss $
from template import *
import wx
import unittest, time, os, shutil
maxCount = 1000000000

from PyRx.preferences import global_preferences
class Test_AutoDockWizard(Test):

    def runAutoDock(self, ligand='HIS.pdb', macromol='1crn.pdb'):
        try:
            if os.path.exists(self.macroPath):
                shutil.rmtree(self.macroPath)
        except Exception, e:
            print e
        fileName = os.path.join(dataDir, ligand)

        fileName = os.path.join(dataDir, ligand)
        mol = self.frame.molNav.TryOpenMolecule(fileName)
        self.frame.molNav.OnMakeLigand(None)
        fileName = os.path.join(dataDir, macromol)
        mol = self.frame.molNav.TryOpenMolecule(fileName)
        self.frame.molNav.OnMakeMacromolecule(None)

        self.frame.autodockWiz.startPage.Start(None)
        moleculesPage = self.frame.autodockWiz.selectMoleculesPage
        moleculesPage.SetActive(None)
        if not self.frame.autodockNav.autodockTree.ligandTree.tree.GetSelections():
            item = self.frame.autodockNav.autodockTree.ligandTree.treeDict[self.ligPath]            
            self.frame.autodockNav.autodockTree.ligandTree.tree.SelectItem(item)

        if not self.frame.autodockNav.autodockTree.macromoleculeTree.tree.GetSelections():
            item = self.frame.autodockNav.autodockTree.macromoleculeTree.treeDict[self.macroPath]
            self.frame.autodockNav.autodockTree.macromoleculeTree.tree.SelectItem(item, True)
        
        self.assertTrue(os.path.exists(self.ligPath))
        self.assertTrue(os.path.exists(os.path.join(self.macroPath, macromol+'qt')))     
        moleculesPage.Next(None)
        self.frame.autodockWiz.runAutoGrid.SetActive(None)
        self.frame.autodockWiz.runAutoGrid.Next(None)
        counter = 1
        while not self.frame.autodockWiz.book.Enabled:
            wx.Yield()
            counter += 1
            if counter > maxCount:
                self.fail("Can't finish AutoGrid after "+str(maxCount)+" tries.")
        self.frame.autodockWiz.runAutoDock.SetActive(None)
        self.frame.autodockWiz.runAutoDock.Next(None)
        counter = 1
        while not self.frame.autodockWiz.analyzePage.dockings:
            wx.Yield()
            counter += 1
            if counter > maxCount:
                self.fail("Can't finish AutoDock after "+str(maxCount)+" tries.")

    def test_local(self):
        "tests AutoDock Wizard with Local execution mode : ligand='HIS.pdb' and macromol='1crn.pdb'"
        global_preferences.set('AutoDock.executionMode', 0)
        global_preferences.flush()               
        self.runAutoDock()
        self.assertTrue(self.frame.autodockWiz.analyzePage.dockings)
        
    def test_remote(self):
        "tests AutoDock Wizard with Remote execution mode : ligand='HIS.pdb' and macromol='1crn.pdb'"
        global_preferences.set('AutoDock.executionMode', 1)
        global_preferences.flush()               
        self.runAutoDock()
        self.assertTrue(self.frame.autodockWiz.analyzePage.dockings)
        
if __name__ == '__main__':
    unittest.main()