#$Id: testMolNavigator.py 290 2017-01-14 21:05:09Z sarkiss $
from template import Test, dataDir, Event
import wx
import unittest
import os

class TestMolNavigator(Test):
    def testReadMolecule(self):
        ligand = "HIS.pdb"
        macromol = '1crn.pdb' 
        fileName = os.path.join(dataDir, ligand)
        self.frame.molNav.TryOpenMolecule(fileName)
        self.frame.molNav.OnRemoveAll(None)
        fileName = os.path.join(dataDir, ligand)
        mol = self.frame.molNav.TryOpenMolecule(fileName)
        self.frame.molNav.OnMakeLigand(None)
        fileName = os.path.join(dataDir, macromol)
        mol = self.frame.molNav.TryOpenMolecule(fileName)
        self.frame.molNav.OnMakeMacromolecule(None)
        self.frame.molNav.OnRemoveAll(None)

    def testMakeMacromoleculeAlt(self):
        "2gdz has alternate conformations"
        id = "2gdz"
        macromol = id+'.pdb'
        fileName = os.path.join(dataDir, macromol)
        mol = self.frame.molNav.TryOpenMolecule(fileName)   
        def clickOK():
            clickEvent = wx.CommandEvent(wx.wxEVT_COMMAND_BUTTON_CLICKED, wx.ID_OK)
            self.frame.autodockNav.dlg.ProcessEvent(clickEvent)
            def clickOK():
                clickEvent = wx.CommandEvent(wx.wxEVT_COMMAND_BUTTON_CLICKED, wx.ID_OK)
                self.frame.autodockNav.dlg.ProcessEvent(clickEvent)     
            wx.CallLater(100,clickOK)        
                 
        wx.CallAfter(clickOK)        
        self.frame.molNav.OnMakeMacromolecule(None)
        self.assertTrue(os.path.exists(os.path.join(self.frame.vsModel.macromoleculesFolder, id)))
    
    def test_show_h_bonds(self):
        "test show_h_bonds"
        macromol = '1crn.pdb' 
        fileName = os.path.join(dataDir, macromol)
        mol = self.frame.molNav.TryOpenMolecule(fileName)
        class Event:
            def IsChecked(self):
                return True
        self.frame.molNav.OnHBonds(Event())      
        class Event:
            def IsChecked(self):
                return False
        self.frame.molNav.OnHBonds(Event())
        ligand = "HIS.pdb"
        fileName = os.path.join(dataDir, ligand)
        self.frame.molNav.TryOpenMolecule(fileName)
        self.frame.molNav.OnRemoveAll(None)
        
if __name__ == '__main__':
    unittest.main()