#!/usr/bin/env python

# bring in the ZSI-generated interface
from PUG_client import *

# other modules/functions
from time import sleep
from urllib import urlretrieve


def DownloadCIDs():
    
    # get a PUG SOAP port instance
    loc = PUGLocator()
    port = loc.getPUGSoap()
    
    # start with a list of CIDs
    req = InputListSoapIn()
    req.set_element_ids(req.new_ids())
    req.get_element_ids().set_element_int([ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 ])
    req.set_element_idType('eID_CID')
    listKey = port.InputList(req).get_element_ListKey()
    print 'ListKey =', listKey
    
    # request download in SDF format, gzip-compressed
    req = DownloadSoapIn();
    req.set_element_ListKey(listKey)
    req.set_element_eFormat('eFormat_SDF')
    req.set_element_eCompress('eCompress_GZip')
    downloadKey = port.Download(req).get_element_DownloadKey()
    print 'DownloadKey =', downloadKey
    
    # call GetOperationStatus until the operation is finished
    req = GetOperationStatusSoapIn()
    req.set_element_AnyKey(downloadKey)
    status = port.GetOperationStatus(req).get_element_status()
    while (status == 'eStatus_Queued' or status == 'eStatus_Running'):
        print 'Waiting for operation to finish...'
        sleep(10)
        status = port.GetOperationStatus(req).get_element_status()
        
    # check status
    if (status == 'eStatus_Success'):
        
        # get the url of the prepared file
        req = GetDownloadUrlSoapIn()
        req.set_element_DownloadKey(downloadKey)
        url = port.GetDownloadUrl(req).get_element_url()
        print 'Success! URL =', url
        
        # download to a local file
        (filename, headers) = urlretrieve(url,
            '.' + url[url.rfind('/') : ])
        print 'Downloaded to ', filename
        
    else:   # status indicates error
        
        # see if there's some explanatory message
        req = GetStatusMessageSoapIn()
        req.set_element_AnyKey(downloadKey)
        print 'Error:', port.GetStatusMessage(req).get_element_message()


if __name__ == '__main__':
    DownloadCIDs()


# $Id: DownloadCIDs.py,v 1.1 2009/05/01 22:37:47 sargis Exp $
