#$Id: autodockWizard.py 91 2011-02-07 23:01:27Z sarkiss $
""" autoDockWizard.py contains StartPage and AutoDockWizard.
"""
import wx, wx.aui, os
from wx.lib import flatnotebook 
import utils
import pickle
import shutil
from webServices import QueryRemoteJobs
from icons import residuePNG, molPNG, cubePNG, adtPNG, eTablePNG
from preferences import global_preferences
from vsModel import autodockPreferencesPage, autodockRemotePreferencesPage 

class StartPage(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)
        label = wx.StaticText(self, -1, "This wizard will guide you through setting up and running AutoGrid and AutoDock.")
        sizer.Add(label, 0, wx.WEST|wx.NORTH, 5)

        self.infoLabel = wx.StaticText(self, -1, "")
        sizer.Add(self.infoLabel, 1, wx.ALL, 5)
        
        
        self.runAutoDockOptions = ["Local (requires local AutoDock binaries)", "Cluster (Portable Batch System)", "Remote (Opal Web Services)"]
        self.rb = wx.RadioBox(self, -1, "AutoDock Execution Mode", choices=self.runAutoDockOptions)
        self.rb.EnableItem(0, False) #enable when local AutoDock binaries are found
        self.rb.EnableItem(1, False)
        self.Bind(wx.EVT_RADIOBOX, self.EvtRadioBox, self.rb)
        sizer.Add(self.rb, 0, wx.EXPAND)
        
        buttonSizer = wx.BoxSizer(wx.HORIZONTAL)
        
        lin = wx.StaticLine(self)
        startButton = wx.Button(self, wx.ID_FORWARD, "Start")      
        buttonSizer.Add(wx.StaticText(self, -1, "Click on Start button to begin --->"), 0, wx.WEST|wx.NORTH, 5)
        buttonSizer.Add((150, -1), 1, flag=wx.EXPAND | wx.ALIGN_RIGHT)
        buttonSizer.Add(startButton, 0, wx.ALIGN_BOTTOM|wx.ALIGN_RIGHT|wx.EAST|wx.SOUTH, 1)
        
        sizer.Add(lin,0,wx.EXPAND)
        sizer.Add(buttonSizer, 0, wx.EXPAND|wx.ALIGN_BOTTOM)
        self.SetSizer(sizer)
        sizer.SetSizeHints(self)
        
        self.Bind(wx.EVT_BUTTON, self.Start, startButton)
        self.sizer = sizer
#        self.Bind(wx.EVT_SHOW, self.SetActive)
        self.frame = self.TopLevelParent
        
    def Start(self, event):
        self.Parent.SetSelection(1)
        self.frame.navigator.Selection = 1

    def SetActive(self, event):
        "This method is bound to wx.EVT_SHOW, i.e., invoked when this page is shown" 
        if self.Shown:
            if not  autodockPreferencesPage.executionMode == 2:
                ADPath = utils.which(autodockPreferencesPage.autodock)
                if ADPath:
                    self.rb.EnableItem(0, True)
                    qsub = utils.which('qsub')
                    if qsub:
                        self.rb.EnableItem(1, True)
                    else:
                        self.rb.EnableItem(1, False)
                else:
                    self.rb.EnableItem(0, False)
                    self.rb.EnableItem(1, False)
                    autodockPreferencesPage.executionMode = 2
                    
            selection = self.rb.GetSelection()
            if selection == 2:
                autodockPreferencesPage.executionMode = 2
                self.infoLabel.SetLabel( "Autodock Service running at " + autodockRemotePreferencesPage.URI +  " will be used for Virtual Screening.")

            pref = global_preferences
            self.rb.SetSelection(int(pref.get('AutoDock.executionMode')))
            #self.Fit()

    def EvtRadioBox(self, event):
        selection = self.rb.GetSelection()
        
        if selection == 2:
            autodockPreferencesPage.executionMode = 2
            self.infoLabel.SetLabel("Autodock Service running at " 
                                    + autodockRemotePreferencesPage.URI +  " will be used for Virtual Screening.")
        else:
            ADPath = utils.which(autodockPreferencesPage.autodock)
            if not ADPath:
                self.infoLabel.SetLabel("Please set Autodock path using Edit -> Preferences....")                
                self.SetActive(event)
                return
            if selection in [0, 1]:
                self.infoLabel.SetLabel(ADPath+" will be used for Virtual Screening.\n"+ 
                                        "Maximum number of simultaneous jobs: " + str(autodockPreferencesPage.cpu_num) )
            autodockPreferencesPage.executionMode = 2
        pref = global_preferences
        pref.set('AutoDock.executionMode', selection)
        pref.flush()
        self.SetActive(event)
        
class AutoDockWizard(wx.Panel):
    def __init__(self, frame):
        wx.Panel.__init__(self, frame, -1)
        book = wx.Notebook(self, wx.ID_ANY)
        self.book = book        
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(book, 1, wx.EXPAND)     
        self.SetSizer(sizer)       
        self.sizer = sizer
        self.CreateIcons()
        startPage = StartPage(book)
        book.AddPage(startPage, "Start Here", imageId=0)
        self.startPage = startPage
        from selectMolecules import SelectMoleculesPage
        selectMoleculesPage = SelectMoleculesPage(book)
        book.AddPage(selectMoleculesPage, "Select Molecules", imageId=1)
        self.selectMoleculesPage = selectMoleculesPage
        from autogridPage import RunAutoGrid        
        runAutoGrid = RunAutoGrid(book)
        book.AddPage(runAutoGrid, "Run AutoGrid", imageId=3)        
        self.runAutoGrid = runAutoGrid
        from autodockPage import RunAutoDock
        runAutoDock = RunAutoDock(book)
        book.AddPage(runAutoDock, "Run AutoDock", imageId=4)
        self.runAutoDock = runAutoDock
        from analyzePage import Analyze
        analyze = Analyze(book)
        book.AddPage(analyze, "Analyze Results", imageId=5)
        self.analyzePage = analyze
        frame.controls.AddPage(self, "AutoDock Wizard", bitmap=adtPNG)
        
        self.frame = frame
        book.SetSelection(0)
        wx.EVT_NOTEBOOK_PAGE_CHANGED(self.book, -1, self.PageChanged)

        ID_DLG = wx.NewId()
        frame.toolBar.AddLabelTool(ID_DLG, "Load DLG", adtPNG,
                                  shortHelp="Load Docking Log File (DLG)", longHelp="Load Docking Log File (DLG)")

        frame.Bind(wx.EVT_TOOL, analyze.Open, id=ID_DLG)        
                
        from webServices import AutoDockWebService
        self.frame.autodockWS = AutoDockWebService(self.frame)
        if not utils.which(autodockPreferencesPage.autodock):
            autodockPreferencesPage.autodockPreferencesPage = 2
            startPage.rb.SetSelection(2)
            startPage.Sizer.FitInside(startPage)
        else:
            startPage.rb.EnableItem(0, True)
        wx.CallAfter(startPage.SetActive, None)
        
        remoteJobsFilePath = os.path.join(self.frame.vsModel.etcFolder,'RemoteJobs')
        if os.path.exists(remoteJobsFilePath):
            if os.path.exists(remoteJobsFilePath+"_old"):
                jobsList = open(remoteJobsFilePath).readlines()
                jobsList.extend(open(remoteJobsFilePath+"_old").readlines())
                jobsList = list(set(jobsList))    
                open(remoteJobsFilePath+"_old", 'w').writelines(jobsList)
                os.remove(remoteJobsFilePath)
            else:
                open(remoteJobsFilePath+"_old", 'w').write(open(remoteJobsFilePath).read())
            wx.FutureCall(100, QueryRemoteJobs, remoteJobsFilePath+"_old", self.frame)
        elif os.path.exists(remoteJobsFilePath+"_old"):
            wx.FutureCall(100, QueryRemoteJobs, remoteJobsFilePath+"_old", self.frame)
                
    def PageChanged(self, event):
        if self.TopLevelParent: #make sure that SetActive is not called on Exit
            self.book.GetPage(event.GetSelection()).SetActive(event)
        event.Skip()
        
    def CreateIcons(self):
        imageSize = (16,16)
        il = wx.ImageList(16,16)
        self.il = il
        tip = wx.ArtProvider.GetBitmap(wx.ART_TIP, wx.ART_TOOLBAR, imageSize)
        il.Add(tip)   
        il.Add(residuePNG)   
        il.Add(molPNG)
        il.Add(cubePNG)
        il.Add(adtPNG)   
        il.Add(eTablePNG)
        self.book.SetImageList(il)     
        