#$Id: autogridPage.py 110 2011-07-07 21:15:03Z sarkiss $
"""AutoGridPage.py contains the following classes.
"""
import wx, os, glob
from wx.lib.buttons import ThemedGenBitmapTextButton
from enthought import tvtk
import runProcess
import utils
from AutoDockTools.GridParameters import GridParameters
from vsModel import autodockPreferencesPage, autodockRemotePreferencesPage 
from time import strftime

class RunAutoGrid(wx.Panel):
    def __init__(self, parent):
        self.flagRunAutoGrid = False
        wx.Panel.__init__(self, parent, -1)
        sizer = wx.BoxSizer(wx.VERTICAL)
        topSizer = wx.BoxSizer(wx.HORIZONTAL)
        listBoxSizer = wx.BoxSizer(wx.VERTICAL)
        listBoxSizer.Add(wx.StaticText(self, -1, "AutoDock Elements:"), 0, wx.LEFT, 10)
        self.listBox = wx.ListBox(self, style=wx.BORDER_SUNKEN)
        listBoxSizer.Add(self.listBox, 1, wx.EXPAND)
        topSizer.Add(listBoxSizer, 1, wx.EXPAND)

        listBoxSizer = wx.BoxSizer(wx.VERTICAL)
        #listBoxSizer.Add(wx.StaticText(self, -1, "Grid Parameters:"), 0, 5, wx.ALL)        
        from boxUI import AutoGirdBoxUI
        boxWidget = AutoGirdBoxUI()
#        grid = GridUI()
#        self.grid = grid
        view = boxWidget.View()

        boxUI = view.ui(boxWidget, self, kind='subpanel')
        listBoxSizer.Add(boxUI.control, 1, wx.EXPAND)
        topSizer.Add(listBoxSizer, 1, wx.EXPAND)
        sizer.Add(topSizer, 1, wx.EXPAND, wx.ALIGN_BOTTOM)
        
        self.forwardButton = wx.Button(self, wx.ID_FORWARD, "")
        self.backButton = wx.Button(self, wx.ID_BACKWARD, "") 
        bitmap = wx.ArtProvider_GetBitmap(wx.ART_EXECUTABLE_FILE, wx.ART_BUTTON)
        runAutoGridButton = ThemedGenBitmapTextButton(self, -1, bitmap, "Run AutoGrid")
        buttonSizer = wx.BoxSizer(wx.HORIZONTAL)
       
        lin = wx.StaticLine(self)
        buttonSizer.Add(runAutoGridButton, 0)
        
        buttonSizer.Add((150, -1), 1, flag=wx.EXPAND | wx.ALIGN_RIGHT)
        buttonSizer.Add(self.backButton, 0, wx.ALIGN_RIGHT)
        buttonSizer.Add(self.forwardButton, 0, wx.ALIGN_RIGHT)
        
        sizer.Add(lin,0,wx.EXPAND)
        sizer.Add(buttonSizer, 0, wx.EXPAND|wx.ALIGN_BOTTOM)
        self.SetSizer(sizer)
        self.Bind(wx.EVT_BUTTON, self.Next, self.forwardButton)
        self.Bind(wx.EVT_BUTTON, self.Back, self.backButton)
        self.Bind(wx.EVT_BUTTON, self.Run, runAutoGridButton)
        #self.Bind(wx.EVT_SHOW, self.SetActive)
        self.frame = self.TopLevelParent
        self.vsModel = self.frame.vsModel       

        boxWidget.set(interactor=self.frame.mayaviEngine.scene.interactor)
        boxWidget.set(place_factor=1)
        boxWidget.rotation_enabled = False
        boxWidget.key_press_activation = False
        boxWidget.add_observer("InteractionEvent", boxWidget.ChangeBox)
        self.boxWidget = boxWidget
        
    def SetActive(self, event):
        "This method is bound to wx.EVT_SHOW, i.e., invoked when this page is shown"
        #check if ligand_types are set
        if not self.frame.autodockWiz.selectMoleculesPage.ligandPass:
            dlg = wx.MessageDialog(self, "Please select a ligand!",'A Message Box',
                                   wx.OK| wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()            
            wx.CallAfter(self.Parent.SetSelection, 1)            
            return
        #check if macromoleculePath is set
        if not self.frame.autodockWiz.selectMoleculesPage.macromoleculePass:
            dlg = wx.MessageDialog(self, "Please select macromolecule!",'A Message Box',
                                   wx.OK| wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()            
            wx.CallAfter(self.Parent.SetSelection, 2)
            return
        #now read macromolecule if necessary
        macromoleculePath = self.vsModel.macromoleculePath
        tmp, ext = os.path.splitext(macromoleculePath)
        basePath, molName = os.path.split(tmp)
        
        if not molName in self.frame.molNav.moleculesNames:
            macromolecule = self.frame.molNav.TryOpenMolecule(macromoleculePath)[0]
            self.frame.renderer3D.Modified()
        else:
            index = self.frame.molNav.moleculesNames.index(molName)
            macromolecule = self.frame.molNav.molecules[index]
            
        if not macromolecule:
            dlg = wx.MessageDialog(self, "Problems reading macromolecule. Please make sure macromolecule is a proper pdbqt file:\n"+macromoleculePath,'A Message Box',
                                   wx.OK| wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()            
            wx.CallAfter(self.Parent.SetSelection, 2)
            return
        
        self.vsModel.macromolecule = macromolecule
        self.vsModel.receptorFolder = basePath
        self.vsModel.receptor_filename = molName+ext
        self.vsModel.receptor_filename = self.vsModel.receptor_filename.encode()
        self.vsModel.receptor_stem = molName.encode()

        flexPath = os.path.join(basePath, molName+"_flex.pdbqt")
        if os.path.exists(flexPath): #add flex resudue atom types
            from AutoDockTools.atomTypeTools import AutoDock4_AtomTyper
            from MolKit.pdbParser import PdbqtParser
            parser = PdbqtParser(flexPath)
            molecules = parser.parse()
            ad4_typer = AutoDock4_AtomTyper()
            ad4_typer.setAutoDockElements(molecules[0])
            self.vsModel.ligand_types =  self.vsModel.ligand_types.union(set(molecules[0].allAtoms.autodock_element))

        self.listBox.Set(list(self.vsModel.ligand_types))
        #activate 3D Graphics tab
        self.frame.view.SetSelection(self.frame.view.GetPageIndex(self.frame.canvas3D))
        self.boxWidget.enabled = True
        if not hasattr(macromolecule, 'box_center') or not (self.boxWidget.X_center and self.boxWidget.Y_center and self.boxWidget.Z_center): #box_center is an arbitrary attribute which is set below   
            center = macromolecule.getCenter()        
            self.boxWidget.X_center, self.boxWidget.Y_center,self.boxWidget.Z_center = center
            self.boxWidget.initCenter = tuple(center)
            bounds = macromolecule.assembly.GetBounds()
            self.boxWidget.max_XDimension = int(abs(bounds[1]-bounds[0])/self.boxWidget.initSpacing*1.01)
            self.boxWidget.max_YDimension = int(abs(bounds[3]-bounds[2])/self.boxWidget.initSpacing*1.01)
            self.boxWidget.max_ZDimension = int(abs(bounds[5]-bounds[4])/self.boxWidget.initSpacing*1.01)
            macromolecule.box_center = center
        else:
            center = [self.boxWidget.X_center, self.boxWidget.Y_center,self.boxWidget.Z_center]
        
        #check if we have grid maps
        self.flagRunAutoGrid = True
        mapFiles = glob.glob(basePath+os.sep+'*.map')
        if mapFiles:
            self.flagRunAutoGrid = False
            if not  self.vsModel.ligand_types: #not sure if this is needed?
                self.vsModel.ligand_types = set(['A', 'C', 'HD', 'NA', 'OA', 'N'])
            for ligandType in self.vsModel.ligand_types:
                str = os.path.join(basePath, molName+'.'+ligandType+'.map')
                if str not in mapFiles:
                    self.flagRunAutoGrid = True
                    break      
        else:
            self.flagRunAutoGrid = True
              
        if self.flagRunAutoGrid:
            self.frame.statusBar.SetStatusText("Click Forward to Run AutoGrid for "+molName+".", 0)        
        else:
            gpm = GridParameters()
            gpm.read4(os.path.join(basePath, molName+'.gpf'))
            gridcenter = gpm.data['gridcenter']['value']
            if  gridcenter != 'auto':
                center = gridcenter
            self.boxWidget.spacing = gpm.data['spacing']['value']
            dim = gpm.data['npts']['value']
            self.boxWidget.X_dimension = dim[0]
            self.boxWidget.Y_dimension = dim[1]
            self.boxWidget.Z_dimension = dim[2]

            self.frame.statusBar.SetStatusText("Found AutoGrid maps for "+molName+". Click Forward to use these maps or Run AutoGrid to create new maps.", 0)              
        self.boxWidget.SetCenter(center)      
        self.frame.canvas3D.Refresh()
          
    def Next(self, event):
        "Goto next page"
        if not self.flagRunAutoGrid:
            self.flagRunAutoGrid = not self.vsModel.CheckMaps()
            
        if self.flagRunAutoGrid:
            self.Run(None)     
        else:
            self.Parent.SetSelection(3)
        self.boxWidget.enabled = False
        
    def Back(self, event):
        "Goto previous page"
        self.Parent.SetSelection(1)
        self.boxWidget.enabled = False
    
    def Run(self, event):
        
        self.frame.TryCommand(self.TryRun, None)
        
    def TryRun(self, event):    
        gridParameters = {}
        gridParameters['npts'] = str(self.boxWidget.X_dimension)+','
        gridParameters['npts'] += str(self.boxWidget.Y_dimension)+','
        gridParameters['npts'] += str(self.boxWidget.Z_dimension)
        gridParameters['gridcenter'] = [self.boxWidget.X_center, 
                                        self.boxWidget.Y_center, 
                                        self.boxWidget.Z_center]
        gridParameters['spacing'] = self.boxWidget.spacing
        vsModel = self.vsModel
        if not autodockPreferencesPage.executionMode == 2 and not utils.which(autodockPreferencesPage.autogrid):
            dlg = wx.MessageDialog(self, "Cannot find "+autodockPreferencesPage.autogrid+
                                   ". Use Edit -> Preferences to set AutoGrid path.",  'Command not found.',  wx.OK| wx.ICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()            
            return
        
        vsModel.PrepareGPF(gridParameters=gridParameters)
        autodock_elements = ""
        for item in list(self.vsModel.ligand_types):
            autodock_elements += str(item) +" "        
        args = (self.vsModel.macromolecule.name, len(self.vsModel.macromolecule.allAtoms), strftime("%Y.%m.%d %H:%M:%S"),autodock_elements)
        if not hasattr(self.frame.dbView, 'targetsTable'):
            self.frame.dbView.Activate(None)        
        self.frame.dbView.targetsTable.AddItem(args, deleteOnFirstMatch=True)
        if autodockPreferencesPage.executionMode == 2:
            self.processPanel = self.frame.autodockWS.GetAutogridWSPanel(self.GrandParent, self.CheckResults)
        else:
            if self.Parent.GetPage(0).rb.GetSelection() == 0:
                if os.path.exists(vsModel.glgOutput):
                    os.remove(vsModel.glgOutput)
                self.processPanel = runProcess.ProcessPanel(self.GrandParent, vsModel.gridCommand, 
                                                            vsModel.receptorFolder, vsModel.glgOutput, self.CheckResults)
            else:
                import pbsJobs
                pbsJob = pbsJobs.startAutogrid(self)
                return
        self.frame.statusBar.SetStatusText("Running AutoGrid. Please Wait...", 0)            
        self.frame.view.AddPage(self.processPanel, "Run AutoGrid", select=True)
        self.processPanel.Start()
        self.frame.autodockWiz.book.Disable()
         
    def CheckResults(self, page, outputFile=None, success=False):
        self.frame.view.DeletePage(self.frame.view.GetPageIndex(page))        
        self.frame.autodockWiz.book.Enable()
        if success:
            documentsView = self.frame.documentsView 
            documentsView.ClosePath(outputFile) #to avoid "...has been modified outside of..." message from wx.lib.docview
            documentsView.OpenDocument(outputFile)
            textCtrl = documentsView._docManager.GetCurrentView()._textCtrl
            wx.CallAfter(textCtrl.ScrollToEnd)
            if textCtrl.GetText().find("Successful Completion") == -1:
                self.frame.statusBar.SetStatusText("Unsuccessful AutoGrid Completion. See Log File for Details. ", 0)
            else:
                self.frame.statusBar.SetStatusText("Successful AutoGrid Completion.", 0)
                self.Parent.SetSelection(3)   
                self.frame.autodockNav.RefreshMacroolecules()         
        else:
            self.frame.view.SetSelection(self.frame.view.GetPageIndex(self.frame.canvas3D))
            self.frame.statusBar.SetStatusText("AutoGrid run terminated.", 0)        
        
        self.boxWidget.enabled = False