#$Id: icons.py 104 2011-04-29 19:41:08Z sarkiss $
""" icons.py contains path of icons specific to PyRx
"""

import os
import wx
size = (16,16)
iconsPath = os.path.join(os.path.dirname(__file__),'Images')
pythonPNG = wx.Bitmap(os.path.join(iconsPath,'python.png'))
pythonPNG.SetSize(size)
atomPNG = wx.Bitmap(os.path.join(iconsPath,'atom.png'))
atomPNG.SetSize(size)
cubePNG = wx.Bitmap(os.path.join(iconsPath,'cube.png'))
cubePNG.SetSize(size)
MPNG = wx.Bitmap(os.path.join(iconsPath,'M.png'))
MPNG.SetSize(size)
babelPNG = wx.Bitmap(os.path.join(iconsPath,'openbabel.png'))
babelPNG.SetSize(size)
hbondPNG = wx.Bitmap(os.path.join(iconsPath,'hbond.png'))
hbondPNG.SetSize(size)
selectionPNG = wx.Bitmap(os.path.join(iconsPath,'selection.png'))
selectionPNG.SetSize(size)
volPNG = wx.Bitmap(os.path.join(iconsPath,'vol.png'))
volPNG.SetSize(size)


PyRxIcon = wx.Icon(os.path.join(iconsPath,'PyRx.ico'), wx.BITMAP_TYPE_ICO)

from mglutil.gui.BasicWidgets.Tk import trees
treesIconsPath = os.path.join(trees.__path__[0],'Icons',)
chainPNGPath = os.path.join(treesIconsPath,'chain.png')
chainPNG = wx.Bitmap(chainPNGPath)
chainPNG.SetSize(size)
residuePNG = wx.Bitmap(os.path.join(treesIconsPath,'residue.png'))
residuePNG.SetSize(size)

import Pmv
pmvIconsPath = os.path.join(Pmv.__path__[0],'Icons','16x16')
adtPNG = wx.Bitmap(os.path.join(pmvIconsPath,'adt.png'))
adtPNG.SetSize(size)
molPNGPath = os.path.join(pmvIconsPath,'electroMs16.png')
molPNG = wx.Bitmap(molPNGPath)
molPNG.SetSize(size)

from enthought.traits.ui import wx as ewx
ewxImages = os.path.join(ewx.__path__[0], 'images')
eTablePNG = wx.Bitmap(os.path.join(ewxImages,'table_display.png'))                       
eTablePNG.SetSize(size)

silk_iconsPath =  os.path.join(iconsPath,'silk_icons')
chart_curvePNG = wx.Bitmap(os.path.join(silk_iconsPath,'chart_curve.png')) 
chart_curvePNG.SetSize(size)
chart_barPNG = wx.Bitmap(os.path.join(silk_iconsPath,'chart_bar.png')) 
chart_barPNG.SetSize(size)
tablePNG = wx.Bitmap(os.path.join(silk_iconsPath,'table.png'))
tablePNG.SetSize(size)
table_refreshPNG = wx.Bitmap(os.path.join(silk_iconsPath,'table_refresh.png'))
table_refreshPNG.SetSize(size)
table_savePNG = wx.Bitmap(os.path.join(silk_iconsPath,'table_save.png'))
table_savePNG.SetSize(size)
database_savePNG = wx.Bitmap(os.path.join(silk_iconsPath,'database_save.png'))
database_savePNG.SetSize(size)
table_row_deletePNG = wx.Bitmap(os.path.join(silk_iconsPath,'table_row_delete.png'))
table_row_deletePNG.SetSize(size)
folder_tablePNG = wx.Bitmap(os.path.join(silk_iconsPath,'folder_table.png'))
folder_tablePNG.SetSize(size)
table_row_deletePNG = wx.Bitmap(os.path.join(silk_iconsPath,'table_row_delete.png'))
table_row_deletePNG.SetSize(size)
