#$Id: textView.py 91 2011-02-07 23:01:27Z sarkiss $
"""textView.py is used for Documents tab in the main window.
"""
import wx
import wx.aui
import os
ID_NEW = wx.NewId()
ID_OPEN = wx.NewId()
import wx.lib.docview

class TextEditDocument(wx.lib.docview.Document):
    "This was taken from wxPython-src-2.8.6.0/wxPython/samples/docview/DocViewDemo.py"
    def OnSaveDocument(self, filename):
        view = self.GetFirstView()
        if not view.GetTextCtrl().SaveFile(filename):
            return False
        self.Modify(False)
        self.SetDocumentSaved(True)
##        if wx.Platform == "__WXMAC__":
##            fn = wx.Filename(filename)
##            fn.MacSetDefaultTypeAndCreator()
        return True

    def OnOpenDocument(self, filename):
        view = self.GetFirstView()
        if not view.GetTextCtrl().LoadFile(filename):
            return False
        self.SetDocumentModificationDate()
        self.SetFilename(filename, True)
        self.Modify(False)
        self.UpdateAllViews()
        self._savedYet = True
        return True

    def IsModified(self):
        view = self.GetFirstView()
        if view:
            return wx.lib.docview.Document.IsModified(self) or (view.GetTextCtrl() and view.GetTextCtrl().IsModified())
        else:
            return wx.lib.docview.Document.IsModified(self)

    def Modify(self, mod):
        view = self.GetFirstView()
        wx.lib.docview.Document.Modify(self, mod)


class TextEditView(wx.lib.docview.View):
    "This was taken from wxPython-src-2.8.6.0/wxPython/samples/docview/DocViewDemo.py"        
    def OnCreate(self, doc, flags):
        self._frame = DocChildPanel(doc, self)
        self.SetFrame(self._frame)
        sizer = wx.BoxSizer()
        self._textCtrl = MyTextWindow(self, self._frame, wx.DefaultPosition, wx.DefaultSize, wx.TE_MULTILINE|wx.FONTFAMILY_TELETYPE)
        self._textCtrl.Bind(wx.stc.EVT_STC_CHANGE, self.OnModify)        
        self._textCtrl.Bind(wx.EVT_FIND, self.OnFind)
        self._textCtrl.Bind(wx.EVT_FIND_NEXT, self.OnFind)
        self._textCtrl.Bind(wx.EVT_FIND_CLOSE, self.OnFindClose)
        aTable = wx.AcceleratorTable([(wx.ACCEL_CTRL, ord('F'), wx.ID_FIND),
                                      (wx.ACCEL_NORMAL, wx.WXK_F3, wx.ID_FIND)
                                      ])
        self._textCtrl.SetAcceleratorTable(aTable)
        
        sizer.Add(self._textCtrl, 1, wx.EXPAND, 0)
        self._frame.SetSizer(sizer)
        self._frame.Layout()
        self._frame.Show(True)
        self.Activate(True)
        self.finddata = wx.FindReplaceData()
        self.finddata.SetFlags(wx.FR_DOWN)
        self.finddlg = None
        return True
            
    def GetTextCtrl(self):
        return self._textCtrl

    def OnModify(self, event):
        self.GetDocument().Modify(True)

    def OnChangeFilename(self):
        """
        Called when the filename has changed. The default implementation
        constructs a suitable title and sets the title of the view frame (if
        any).
        """
        self._frame.SetTitle(self.GetDocument().GetPrintableName())

    def OnUpdate(self, sender, hint):
        """
        Called when the view should be updated. sender is a pointer to the
        view that sent the update request, or NULL if no single view requested
        the update (for instance, when the document is opened). hint is as yet
        unused but may in future contain application-specific information for
        making updating more efficient.
        """
        if hint:
            if hint[0] == "modify":  # if dirty flag changed, update the view's displayed title
                frame = self.GetFrame()
                if frame and hasattr(frame, "OnTitleIsModified"):
                    frame.OnTitleIsModified()
                    return True
        return False

    def OnClose(self, deleteWindow=True):
        """
        Implements closing behaviour. The default implementation calls
        wxDocument.Close to close the associated document. Does not delete the
        view. The application may wish to do some cleaning up operations in
        this function, if a call to wxDocument::Close succeeded. For example,
        if your application's all share the same window, you need to
        disassociate the window from the view and perhaps clear the window. If
        deleteWindow is true, delete the frame associated with the view.
        """
        if self.GetDocument():
            #tmp = self.GetDocument().Close()
            if deleteWindow:
                try:
                    index = self._frame.notebook.GetPageIndex(self._frame)
                    self._frame.notebook.DeletePage(index)
                except Exception, inst:
                    pass
                    #print  inst
            return True
        else:
            return True

    # Since ProcessEvent is not virtual, we have to trap the relevant events using this pseudo-ProcessEvent instead of EVT_MENU
    def ProcessEvent(self, event):
        id = event.GetId()
        if id == wx.ID_UNDO:
            if not self._textCtrl:
                return False
            self._textCtrl.Undo()
            return True
        elif id == wx.ID_REDO:
            if not self._textCtrl:
                return False
            self._textCtrl.Redo()
            return True
        elif id == wx.ID_CUT:
            if not self._textCtrl:
                return False
            self._textCtrl.Cut()
            return True
        elif id == wx.ID_COPY:
            if not self._textCtrl:
                return False
            self._textCtrl.Copy()
            return True
        elif id == wx.ID_PASTE:
            if not self._textCtrl:
                return False
            self._textCtrl.Paste()
            return True
#        elif id == wx.ID_CLEAR:
#            if not self._textCtrl:
#                return False
#            self._textCtrl.Replace(self._textCtrl.GetSelection()[0], self._textCtrl.GetSelection()[1], '')
#            return True
#        elif id == wx.ID_SELECTALL:
#            if not self._textCtrl:
#                return False
#            self._textCtrl.SetSelection(-1, -1)
#            return True
#        elif id == TextService.CHOOSE_FONT_ID:
#            if not self._textCtrl:
#                return False
#            self.OnChooseFont(event)
#            return True
#        elif id == TextService.WORD_WRAP_ID:
#            if not self._textCtrl:
#                return False
#            self.OnWordWrap(event)
#            return True
        elif id == wx.ID_FIND:
            self.OnHelpFind(event)
            return True
#        elif id == FindService.FindService.FIND_PREVIOUS_ID:
#            self.DoFind(forceFindPrevious = True)
#            return True
#        elif id == FindService.FindService.FIND_NEXT_ID:
#            self.DoFind(forceFindNext = True)
#            return True
#        elif id == FindService.FindService.REPLACE_ID:
#            self.OnFind(replace = True)
#            return True
#        elif id == FindService.FindService.FINDONE_ID:
#            self.DoFind()
#            return True
#        elif id == FindService.FindService.REPLACEONE_ID:
#            self.DoFind(replace = True)
#            return True
#        elif id == FindService.FindService.REPLACEALL_ID:
#            self.DoFind(replaceAll = True)
#            return True
#        elif id == FindService.FindService.GOTO_LINE_ID:
#            self.OnGotoLine(event)
#            return True
        else:
            return wx.lib.docview.View.ProcessEvent(self, event)


    def ProcessUpdateUIEvent(self, event):
        if not self._textCtrl:
            return False

        id = event.GetId()
        if id == wx.ID_UNDO:
            event.Enable(self._textCtrl.CanUndo())
            return True
        elif id == wx.ID_REDO:
            event.Enable(self._textCtrl.CanRedo())
            return True
        if id == wx.ID_CUT:
            return True
        elif id == wx.ID_COPY:
            return True
        elif id == wx.ID_PASTE:
            event.Enable(self._textCtrl.CanPaste())
            return True
#        elif id == wx.ID_CLEAR:
#            event.Enable(self._textCtrl.CanCopy())
#            return True
#        elif id == wx.ID_SELECTALL:
#            event.Enable(hasText)
#            return True
#        elif id == TextService.CHOOSE_FONT_ID:
#            event.Enable(True)
#            return True
#        elif id == TextService.WORD_WRAP_ID:
#            event.Enable(True)
#            return True
#        elif id == FindService.FindService.FIND_ID:
#            event.Enable(hasText)
#            return True
#        elif id == FindService.FindService.FIND_PREVIOUS_ID:
#            event.Enable(hasText and
#                         self._FindServiceHasString() and
#                         self._textCtrl.GetSelection()[0] > 0)
#            return True
#        elif id == FindService.FindService.FIND_NEXT_ID:
#            event.Enable(hasText and
#                         self._FindServiceHasString() and
#                         self._textCtrl.GetSelection()[0] < len(self._textCtrl.GetValue()))
#            return True
#        elif id == FindService.FindService.REPLACE_ID:
#            event.Enable(hasText)
#            return True
#        elif id == FindService.FindService.GOTO_LINE_ID:
#            event.Enable(True)
#            return True
        else:
            return wx.lib.docview.View.ProcessUpdateUIEvent(self, event)


    def OnHelpFind(self, event):
        if self.finddlg != None:
            return
        self.finddlg = wx.FindReplaceDialog(self._textCtrl, self.finddata, "Find",
                        wx.FR_NOMATCHCASE | wx.FR_NOWHOLEWORD)
        self.finddlg.Show(True)


    def OnUpdateFindItems(self, evt):
        evt.Enable(self.finddlg == None)


    def OnFind(self, event):
        editor = self._textCtrl

        end = editor.GetLength()
        textstring = editor.GetTextRange(0, end).lower()
        findstring = self.finddata.GetFindString().lower()
        backward = not (self.finddata.GetFlags() & wx.FR_DOWN)
        if backward:
            start = editor.GetAnchor()
            loc = textstring.rfind(findstring, 0, start)
        else:
            start = editor.GetCurrentPos()
            loc = textstring.find(findstring, start)
        if loc == -1 and start != 0:
            # string not found, start at beginning
            if backward:
                start = end
                loc = textstring.rfind(findstring, 0, start)
            else:
                start = 0
                loc = textstring.find(findstring, start)
        if loc == -1:
            dlg = wx.MessageDialog(editor, 'Find String Not Found',
                          'Find String Not Found in Demo File',
                          wx.OK | wx.ICON_INFORMATION)
            dlg.ShowModal()
            dlg.Destroy()
        if self.finddlg:
            if loc == -1:
                self.finddlg.SetFocus()
                return
            else:
                self.finddlg.Destroy()
                self.finddlg = None
        line = editor.LineFromPosition(loc)
        editor.GotoLine(line)
        editor.SetSelectionStart(loc)
        editor.SetSelectionEnd(loc + len(findstring))

    def OnFindNext(self, event):
        if self.finddata.GetFindString():
            self.OnFind(event)
        else:
            self.OnHelpFind(event)

    def OnFindClose(self, event):
        event.GetDialog().Destroy()
        self.finddlg = None

import  wx.stc  as  stc


class MyTextWindow(stc.StyledTextCtrl):
    "This was taken from wxPython/samples/docview/DocViewDemo.py"    
    def __init__(self, view, frame, pos, size, style):
        super(MyTextWindow, self).__init__(frame, -1, pos, size, style)
        self._view = view
        self.SetLexer(stc.STC_LEX_NULL)
        self.StyleSetSpec(stc.STC_STYLE_DEFAULT, "size:%d,face:%s" % (10, "Courier New"))
        self.StyleClearAll()
            
        
    def IsModified(self):
        return self.GetModify()

    def ScrollToEnd(self):
        endpoint = self.GetLength()
        line = self.LineFromPosition( endpoint )
        self.ScrollToLine(line)
    
class DocChildPanel(wx.Panel):
    """
    This was taken from wx.lib.docview.wxDocMDIChildFrame.
    Modified to work with wx.aui.AuiNotebook and provides a Panel for displaying
    documents on separate pages of the AuiNotebook. T
    """

    def __init__(self, doc, view):
        """
        Constructor.  Note that the event table must be rebuilt for the
        frame since the EvtHandler is not virtual.
        """
        self.notebook = doc.GetDocumentManager().notebook        
        wx.Panel.__init__(self, self.notebook)
        self.notebook.AddPage(self, "", select=True)        
        self.pageIndex = self.notebook.GetPageIndex(self)

        self._childDocument = doc
        self._childView = view
        if view:
            view.SetFrame(self)
        # self.Create(doc, view, frame, id, title, pos, size, style, name)
        self._activeEvent = None
        self._activated = 0
        #self.notebook.Bind(wx.aui.EVT_AUINOTEBOOK_PAGE_CLOSED, self.PageClosed)
        self.notebook.Bind(wx.aui.EVT_AUINOTEBOOK_PAGE_CLOSE, self.OnCloseWindow)
        self.notebook.Bind(wx.aui.EVT_AUINOTEBOOK_PAGE_CHANGED, self.OnPageChanged)

    def OnPageChanged(self, event):
        """
        This ensures that EVT_AUINOTEBOOK_PAGE_CLOSE is called with appropriate Panel. 
        Otherwise it was called for the last panel and caused problems with closing.
        """
        pageIndex = event.EventObject.GetSelection()
        if pageIndex == -1:
            return
        panel = event.EventObject.GetPage(pageIndex)
        panel.notebook.Bind(wx.aui.EVT_AUINOTEBOOK_PAGE_CLOSE, panel.OnCloseWindow)
        if hasattr(panel, '_childDocument'):
            #we need this to update toolbar
            panel._childDocument.GetDocumentManager().ActivateView(panel._childView)
            return wx.lib.docview.View.ProcessUpdateUIEvent(panel._childView, event)
        
    def OnCloseWindow(self, event):
        """
        Closes and deletes the current view and document.
        """
        if self._childView:
            ans = self._childView.Close(deleteWindow = False)
            if ans:
                self._childView.Activate(False)
                self._childView.Destroy()
                self._childView = None
                if self._childDocument:  # This isn't in the wxWindows codebase but the document needs to be disposed of somehow
                    self._childDocument.DeleteContents()
                    if self._childDocument.GetDocumentManager():
                        self._childDocument.GetDocumentManager().RemoveDocument(self._childDocument)
                self._childDocument = None
            else:
                event.Veto()
        else:
            event.Veto()

    def GetDocument(self):
        """
        Returns the document associated with this frame.
        """
        return self._childDocument


    def SetDocument(self, document):
        """
        Sets the document for this frame.
        """
        self._childDocument = document


    def GetView(self):
        """
        Returns the view associated with this frame.
        """
        return self._childView


    def SetView(self, view):
        """
        Sets the view for this frame.
        """
        self._childView = view

    def OnTitleIsModified(self):
        """
        Add/remove to the frame's title an indication that the document is dirty.
        If the document is dirty, an '*' is appended to the title
        This method has been added to wxPython and is not in wxWindows.
        """
        title = self.GetTitle()
        if title:
            if self.GetDocument().IsModified():
                if title.endswith("*"):
                    return
                else:
                    title = title + "*"
                    self.SetTitle(title)
            else:
                if title.endswith("*"):
                    title = title[:-1]
                    self.SetTitle(title)                
                else:
                    return
    def GetTitle(self):
        return self.notebook.GetPageText(self.pageIndex)
    
    def SetTitle(self, title):
        self.notebook.SetPageText(self.pageIndex, title)
        
###################################
_ = wx.GetTranslation

import wx.lib.pydocview

class DocumentsView(wx.Panel):
    """
    This class is used to display documents using wx.lib.docview
    The icons were taken wx.lib.pydocview and the main reason for not using
    pydocview directly is because we are using wx.aui and only part of the application requires docview.
    """
    def __init__(self, frame):
        wx.Panel.__init__(self, frame, -1)
        docManager = wx.lib.docview.DocManager( wx.lib.docview.DOC_MDI | wx.lib.docview.DOC_OPEN_ONCE)
        docManager.AssociateTemplate(wx.lib.docview.DocTemplate(docManager,
                                                     _("Text"),
                                                     "*.*",
                                                     _("."),
                                                     _(".txt"),
                                                     _("Text Document"),
                                                     _("Text View"),
                                                     TextEditDocument,
                                                     TextEditView))   

        tb = wx.ToolBar(self, style=wx.NO_BORDER | wx.TB_FLAT)
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(tb, 0, wx.EXPAND)     
        self.SetSizer(sizer)       
        
        
        tb.AddSimpleTool(wx.ID_NEW, wx.lib.pydocview.New.GetBitmap(), _("New"), _("Creates a new document"))
        tb.AddSimpleTool(wx.ID_OPEN, wx.lib.pydocview.Open.GetBitmap(), _("Open"), _("Opens an existing document"))  
        tb.AddSimpleTool(wx.ID_SAVE,  wx.lib.pydocview.Save.GetBitmap(), _("Save"), _("Saves the active document"))
        tb.AddSimpleTool(wx.ID_SAVEAS, wx.ArtProvider_GetBitmap(wx.ART_FILE_SAVE_AS, size = (16,16)), _("Save As"), _("Saves the active document as"))        
        tb.AddSeparator()
        tb.AddSimpleTool(wx.ID_CUT, wx.lib.pydocview.Cut.GetBitmap(), _("Cut"), _("Cuts the selection and puts it on the Clipboard"))
        tb.AddSimpleTool(wx.ID_COPY, wx.lib.pydocview.Copy.GetBitmap(), _("Copy"), _("Copies the selection and puts it on the Clipboard"))
        tb.AddSimpleTool(wx.ID_PASTE, wx.lib.pydocview.Paste.GetBitmap(), _("Paste"), _("Inserts Clipboard contents"))
        tb.AddSimpleTool(wx.ID_UNDO, wx.lib.pydocview.Undo.GetBitmap(), _("Undo"), _("Reverses the last action"))
        tb.AddSimpleTool(wx.ID_REDO, wx.lib.pydocview.Redo.GetBitmap(), _("Redo"), _("Reverses the last undo"))        
        tb.AddSimpleTool(wx.ID_FIND,  getFindBitmap(), shortHelpString = _("Find"), longHelpString = _("Finds the specified text"))

        tb.Realize()       
        self.notebook = wx.aui.AuiNotebook(self, style=wx.aui.AUI_NB_TOP | 
                                       wx.aui.AUI_NB_TAB_SPLIT | 
                                       wx.aui.AUI_NB_TAB_MOVE | 
                                       wx.aui.AUI_NB_TAB_EXTERNAL_MOVE |
                                       wx.aui.AUI_NB_SCROLL_BUTTONS |
                                       wx.aui.AUI_NB_TAB_FIXED_WIDTH |
                                       wx.aui.AUI_NB_WINDOWLIST_BUTTON|
                                       wx.aui.AUI_NB_CLOSE_ON_ACTIVE_TAB)
        
        docManager.notebook = self.notebook
        
        sizer.Add(self.notebook, 1, wx.EXPAND)     
        self.frame = frame
        
        #self.Bind(wx.EVT_WINDOW_DESTROY, self.OnCloseWindow)
        self._docManager = docManager
        #wx.EVT_CLOSE(self, self.OnCloseWindow)

        wx.EVT_MENU(self, wx.ID_NEW, self.ProcessEvent)
        wx.EVT_MENU(self, wx.ID_OPEN, self.ProcessEvent)
        wx.EVT_MENU(self, wx.ID_SAVE, self.ProcessEvent)
        wx.EVT_MENU(self, wx.ID_SAVEAS, self.ProcessEvent)
        wx.EVT_MENU(self, wx.ID_FIND, self.ProcessEvent)
        
        wx.EVT_MENU(self, wx.ID_CUT, self.ProcessEvent)
        wx.EVT_MENU(self, wx.ID_COPY, self.ProcessEvent)
        wx.EVT_MENU(self, wx.ID_PASTE, self.ProcessEvent)        
        
        wx.EVT_MENU(self, wx.ID_UNDO, self.ProcessEvent)
        wx.EVT_MENU(self, wx.ID_REDO, self.ProcessEvent)

        wx.EVT_UPDATE_UI(self, wx.ID_NEW, self.ProcessUpdateUIEvent)
        wx.EVT_UPDATE_UI(self, wx.ID_OPEN, self.ProcessUpdateUIEvent)
        wx.EVT_UPDATE_UI(self, wx.ID_SAVE, self.ProcessUpdateUIEvent)
        wx.EVT_UPDATE_UI(self, wx.ID_SAVEAS, self.ProcessUpdateUIEvent)
        wx.EVT_UPDATE_UI(self, wx.ID_FIND, self.ProcessUpdateUIEvent)
        wx.EVT_UPDATE_UI(self, wx.ID_CUT, self.ProcessUpdateUIEvent)        
        wx.EVT_UPDATE_UI(self, wx.ID_COPY, self.ProcessUpdateUIEvent)
        wx.EVT_UPDATE_UI(self, wx.ID_PASTE, self.ProcessUpdateUIEvent)                
        
        wx.EVT_UPDATE_UI(self, wx.ID_UNDO, self.ProcessUpdateUIEvent)
        wx.EVT_UPDATE_UI(self, wx.ID_REDO, self.ProcessUpdateUIEvent)

        frame.view.AddPage(self, "Documents", bitmap=wx.lib.pydocview.Paste.GetBitmap())


    def ProcessEvent(self, event):
        """
        Processes an event, searching event tables and calling zero or more
        suitable event handler function(s).  Note that the ProcessEvent
        method is called from the wxPython docview framework directly since
        wxPython does not have a virtual ProcessEvent function.
        """
        try:
            return self._docManager and self._docManager.ProcessEvent(event)
        except:
            pass

    def ProcessUpdateUIEvent(self, event):
        """
        Processes a UI event, searching event tables and calling zero or more
        suitable event handler function(s).  Note that the ProcessEvent
        method is called from the wxPython docview framework directly since
        wxPython does not have a virtual ProcessEvent function.
        """
        try:
            return self._docManager and self._docManager.ProcessUpdateUIEvent(event)
        except:
            pass 

    def OpenDocument(self, path):
        doc = self._docManager.CreateDocument(path, flags=wx.lib.docview.DOC_SILENT|wx.lib.docview.DOC_OPEN_ONCE)
        #activate Documents tab
        self.frame.view.SetSelection(self.frame.view.GetPageIndex(self))
        return doc

    def ClosePath(self, path):
        for document in self._docManager._docs:
            if document.GetFilename() and os.path.normcase(document.GetFilename()) == os.path.normcase(path):          
                pageindex = self.notebook.GetPageIndex(document.GetFirstView()._frame)
                self._docManager._currentView = None
                document.OnCloseDocument()
                document.DeleteAllViews()
                if document in self._docManager._docs:
                    document.Destroy()                
                self.notebook.DeletePage(pageindex)
                                         
    def OnCloseWindow(self, event):
        """
        Deletes all views and documents. If no user input cancelled the
        operation, the frame will be destroyed and the application will exit.
        """
        if self._docManager.Clear(True):
            #self.Destroy()
            return 
        else:
            event.Veto()

#----------------------------------------------------------------------------
# From wxPython/samples/pydocview/FindService.py
#----------------------------------------------------------------------------
from wx import ImageFromStream, BitmapFromImage
import cStringIO


def getFindData():
    return \
'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00\x10\x00\x00\x00\x10\x08\x06\
\x00\x00\x00\x1f\xf3\xffa\x00\x00\x00\x04sBIT\x08\x08\x08\x08|\x08d\x88\x00\
\x00\x01\xb1IDAT8\x8d\xa5\x93=o\xd3P\x14\x86\x1f\xa7\x11\x95<\xdc\xc6\xecN+5\
[\x86B\x99\xacLQ2Zr[\x89\xa1\xfd\x0b%\x95\x90\x00\xf1\x03\x80\x01\x98\x80\
\x19G\xac\x0cm\xff@Y\xd9:\xd9Ck\x94\xd6\xddb\x94\x9b\x98\xc8\xd2e1C\xe5\x8b\
\xdd\x14\x96\xbe\xdb=\x1f\xefy\xef\xf90\x8c\xda\x12wA\xbd\xfc\x18\xfa\x9fs\
\x80\xf9|\x0e\xc0\x93\xc1\x81\x01\xf0\xe6\xf5\xab\x1c`:\x9d\x02\xf0\xf6\xdd{\
\xa3\xc8\xa9\xddd\xec\xf5z\xb4Z\xeb\x00\x1c\x1f\x1d\xe6\x85\xdd\xf3<\x06\x83\
\xc1\x82\xbd\xa2 \x0cCL\xd3d<\x1e\x13\xc71\xb6m\x030\x1a\x8d\x08\x82\x00\x80\
\xb3\xb3s:\x9d\x8e\xce\xa9(h6\x9b8\x8e\x83m\xdb4\x1a\r\x82 \xe0\xc5\xf3g\xb9\
eY\xb4\xdbm\x1c\xc7Y\xe8\x81&\xf8\xf4\xf1C\xde\xedv+\xce\x97Owx\xfc\xe8k\xc5\
\xb6\xb7\xb7\x8b\xef\x0foW \x84\xe0\xea\xea\x02\xa5\x94n\x18\x80\x94\x92\xd9\
l\x02@\x96e\x95>\xd4nVO\xd3\xb9\x0e\xba\r\xa6i\xd2\xef\xf7\xf0\xfd!\xc7G\x87\
y\xed:)\xd5\x01J\xfd\xd6c\xfc~\x9a\xfc\x93\xe8\xf2\xf2\x02(Ma6\x9b \x84@)\
\xa5\t}\xff\x0b\xd0\'I~R\x14\xca\xb2L\xfb\x97\x97\xef-\xeeA!_J\x89\xeb\xba\
\xb8\xae\xab\xbf\x06\x7f\x97\xacP[\x87\xeb9\x0b!H\x92\ta\x18"\xa5\xd4U\xbd\
\xadm\xe3\xe1\x83\x8d<\x8a~\x90\xa6\xbf\x88\xe3\x18)\xa5&\xa9\x03X\x96E\xab\
\xb5\x8em7\xf5\xc2\x94\xb1\xba\xba\xc6\xe6\xe6\x06++\xf7\x89\xa2\xa8\xe2\xd3\
=89\xf9Va.\x14\x14\xd8\xdf?X VJa\x14\xd7X\xde\xef2\xbc\xadm\xe3\x7f~\xe3\xae\
\xe7\xfc\x07\x84;\xc5\x82\xa1m&\x95\x00\x00\x00\x00IEND\xaeB`\x82' 


def getFindBitmap():
    return BitmapFromImage(getFindImage())


def getFindImage():
    stream = cStringIO.StringIO(getFindData())
    return ImageFromStream(stream)