#$Id: update.py 286 2017-01-03 01:24:24Z sarkiss $
"""This module is used for Help --> Check for Updates...
"""
import sys, os, pdb, user, subprocess, urllib, shutil
from about import version
from utils import rcFolder
from download import download
import wx

def DoUpdates(update_url):
    destFile = os.path.join(rcFolder, 'pyrx_update.tar.gz')
    if not download(update_url, destFile): return
    updateFolder = os.path.join(rcFolder, 'update')
    executable = sys.executable
    if os.path.exists(updateFolder): 
        shutil.rmtree(updateFolder)
    os.mkdir(updateFolder)
    script = sys.argv[0]

    if os.name == 'nt':
        executable = executable.replace("\\","""\\\\""")                  
        script = script.replace("\\","""\\\\""")                  
    elif sys.platform == "darwin":
        executable = os.path.join(os.path.split(os.path.split(os.path.split(sys.prefix)[0])[0])[0],"py.sh")
    executable = '"'+executable+'"'
    script = '"'+script+'"'

    txt = """
import time,os,tarfile,subprocess
time.sleep(1)
tarfile.open("%s").extractall("%s")
subprocess.call([%s,%s])
"""%(destFile, updateFolder, executable, script)
    updatePy = os.path.join(rcFolder, 'update.py')
    open(updatePy,'w').write(txt)
    cmd = executable +" " +updatePy
    if os.name == 'nt':                  
        cmd = cmd.encode()
    else:
        cmd += ' &'
        
    subprocess.Popen(cmd, shell=True)
    os._exit(0)    
    
def CheckForUpdates():
    txt = urllib.urlopen("http://pyrx.sourceforge.net/updates/check").readlines()
    update_versions  = txt[0].split('\t')
    upgrade_versions  = txt[1].split('\t')
    frame = wx.GetApp().GetTopWindow()
    if version in update_versions:
        if update_versions[0]:
            updateFolder = os.path.join(rcFolder, 'update')
            if os.path.exists(updateFolder) and os.path.getctime(updateFolder) > float(update_versions[1]): #used time.time() to insert this into check
                dlg = wx.MessageDialog(frame, 'No new updates are available at this time.',
                                       'No Updates', wx.OK | wx.ICON_INFORMATION)
                dlg.ShowModal()
                dlg.Destroy()                         
                return
            dlg = wx.MessageDialog(frame, 'New updates are available.\nWould you like to install them?',
                                   "Updates are Ready", wx.YES_NO | wx.ICON_INFORMATION)
            if dlg.ShowModal() == wx.ID_YES:
                dlg.Destroy()
                DoUpdates(update_versions[0])
            else:
                dlg.Destroy()                
            updateFolder = os.path.join(rcFolder, 'update')            
        else:
            dlg = wx.MessageDialog(frame, 'No updates are available at this time.',
                                   'No Updates', wx.OK | wx.ICON_INFORMATION)
            dlg.ShowModal()
            dlg.Destroy()         
               
    elif version in upgrade_versions:
            dlg = wx.MessageDialog(frame, 'Please visit http://pyrx.sourceforge.net to upgrade your version of PyRx ('+version+').',
                                   "Needs Upgrade", wx.OK | wx.ICON_INFORMATION)
            dlg.ShowModal()
            dlg.Destroy()       
    else:
        dlg = wx.MessageDialog(frame, 'No updates are available at this time.',
                               'No Updates', wx.OK | wx.ICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()          

def Update(event):
    frame = wx.GetApp().GetTopWindow()
    frame.TryCommand(CheckForUpdates)
    