/*
 * Decompiled with CFR 0.152.
 */
package jspecview.dialog;

import java.util.Enumeration;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVTreeNode;
import jspecview.common.Annotation;
import jspecview.common.PanelNode;
import jspecview.dialog.JSVDialog;

public class ViewsDialog
extends JSVDialog {
    private Lst<JSVTreeNode> treeNodes;
    private Lst<Object> checkBoxes;
    private Object closeSelectedButton;
    private Object combineSelectedButton;
    private Object viewSelectedButton;
    private static int[] posXY = new int[]{Integer.MIN_VALUE, 0};
    private boolean checking = false;

    public ViewsDialog() {
        this.type = Annotation.AType.Views;
    }

    @Override
    public int[] getPosXY() {
        return posXY;
    }

    @Override
    protected void addUniqueControls() {
        this.checkBoxes = new Lst();
        this.treeNodes = new Lst();
        this.dialog.addButton("btnSelectAll", "Select All");
        this.dialog.addButton("btnSelectNone", "Select None");
        this.txt2 = this.dialog.addTextField("txtOffset", "Offset", "" + this.vwr.parameters.viewOffset, "%", null, true);
        this.viewSelectedButton = this.dialog.addButton("btnViewSelected", "View Selected");
        this.combineSelectedButton = this.dialog.addButton("btnCombineSelected", "Combine Selected");
        this.closeSelectedButton = this.dialog.addButton("btnCloseSelected", "Close Selected");
        this.dialog.addButton("btnDone", "Done");
        this.dialog.setPreferredSize(800, 350);
        this.txt1 = this.dialog.addCheckBox(null, null, 0, false);
        this.addCheckBoxes(this.vwr.spectraTree.getRootNode(), 0, true);
        this.addCheckBoxes(this.vwr.spectraTree.getRootNode(), 0, false);
    }

    private void addCheckBoxes(JSVTreeNode jSVTreeNode, int n, boolean bl) {
        Enumeration<JSVTreeNode> enumeration = jSVTreeNode.children();
        while (enumeration.hasMoreElements()) {
            JSVTreeNode jSVTreeNode2 = enumeration.nextElement();
            PanelNode panelNode = jSVTreeNode2.getPanelNode();
            if (panelNode.isView != bl) continue;
            String string = panelNode.toString();
            if (string.indexOf("\n") >= 0) {
                string = string.substring(0, string.indexOf(10));
            }
            String string2 = "chkBox" + this.treeNodes.size();
            Object object = this.dialog.addCheckBox(string2, string, n, panelNode.isSelected);
            jSVTreeNode2.setIndex(this.treeNodes.size());
            this.treeNodes.addLast(jSVTreeNode2);
            this.checkBoxes.addLast(object);
            this.addCheckBoxes(jSVTreeNode2, n + 1, bl);
        }
    }

    @Override
    public void checkEnables() {
        int n = 0;
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            if (!this.dialog.isSelected(this.checkBoxes.get(i)) || ((JSVTreeNode)this.treeNodes.get((int)i)).getPanelNode().jsvp == null) continue;
            ++n;
        }
        System.out.println("viewsdialog n=" + n);
        this.dialog.setEnabled(this.closeSelectedButton, n > 0);
        this.dialog.setEnabled(this.combineSelectedButton, n > 1);
        this.dialog.setEnabled(this.viewSelectedButton, n == 1);
    }

    protected void check(String string) {
        int n = PT.parseInt(string.substring(string.indexOf("_") + 1));
        JSVTreeNode jSVTreeNode = (JSVTreeNode)this.treeNodes.get(n);
        Object e = this.checkBoxes.get(n);
        boolean bl = this.dialog.isSelected(e);
        if (jSVTreeNode.getPanelNode().jsvp == null) {
            if (!this.checking && bl && this.dialog.getText(e).startsWith("Overlay")) {
                this.checking = true;
                this.selectAll(false);
                this.dialog.setSelected(e, true);
                jSVTreeNode.getPanelNode().isSelected = true;
                this.checking = false;
            }
            Enumeration<JSVTreeNode> enumeration = jSVTreeNode.children();
            while (enumeration.hasMoreElements()) {
                JSVTreeNode jSVTreeNode2 = enumeration.nextElement();
                this.dialog.setSelected(this.checkBoxes.get(jSVTreeNode2.getIndex()), bl);
                jSVTreeNode2.getPanelNode().isSelected = bl;
                jSVTreeNode.getPanelNode().isSelected = bl;
            }
        } else {
            jSVTreeNode.getPanelNode().isSelected = bl;
        }
        if (bl) {
            n = this.treeNodes.size();
            while (--n >= 0) {
                if (((JSVTreeNode)this.treeNodes.get((int)n)).getPanelNode().isView == jSVTreeNode.getPanelNode().isView) continue;
                this.dialog.setSelected(this.checkBoxes.get(((JSVTreeNode)this.treeNodes.get(n)).getIndex()), false);
                ((JSVTreeNode)this.treeNodes.get((int)n)).getPanelNode().isSelected = false;
            }
        }
        this.checkEnables();
    }

    protected void selectAll(boolean bl) {
        int n = this.checkBoxes.size();
        while (--n >= 0) {
            this.dialog.setSelected(this.checkBoxes.get(n), bl);
            ((JSVTreeNode)this.treeNodes.get((int)n)).getPanelNode().isSelected = bl;
        }
        this.checkEnables();
    }

    protected void combineSelected() {
    }

    protected void viewSelected() {
        SB sB = new SB();
        PanelNode panelNode = null;
        int n = 0;
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            Object e = this.checkBoxes.get(i);
            PanelNode panelNode2 = ((JSVTreeNode)this.treeNodes.get(i)).getPanelNode();
            if (!this.dialog.isSelected(e) || panelNode2.jsvp == null) continue;
            if (panelNode2.isView) {
                panelNode = panelNode2;
                n = 2;
                break;
            }
            ++n;
            String string = this.dialog.getText(e);
            sB.append(" ").append(string.substring(0, string.indexOf(":")));
        }
        String string = null;
        if (n > 1) {
            this.eventApply();
            string = "STACKOFFSETY " + this.vwr.parameters.viewOffset;
        }
        if (panelNode == null) {
            this.vwr.execView(sB.toString().trim(), false);
            this.layoutDialog();
        } else {
            this.vwr.setNode(panelNode);
        }
        if (string != null) {
            this.vwr.runScript(string);
        }
    }

    protected void closeSelected() {
        this.vwr.runScript("close !selected");
        this.layoutDialog();
    }

    @Override
    public boolean callback(String string, String string2) {
        if (string.equals("btnSelectAll")) {
            this.selectAll(true);
        } else if (string.equals("btnSelectNone")) {
            this.selectAll(false);
        } else if (string.equals("btnViewSelected")) {
            this.viewSelected();
        } else if (string.equals("btnCombineSelected")) {
            this.viewSelected();
        } else if (string.equals("btnCloseSelected")) {
            this.closeSelected();
        } else if (string.equals("btnDone")) {
            this.viewSelected();
            this.dispose();
            this.done();
        } else if (string.equals("txtOffset")) {
            this.eventApply();
            this.viewSelected();
        } else if (string.startsWith("chk")) {
            this.checkEnables();
        } else {
            return this.callbackAD(string, string2);
        }
        return true;
    }

    @Override
    public void applyFromFields() {
        this.apply(new Object[]{this.dialog.getText(this.txt2)});
    }
}

