/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.T3;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;

public class CarbohydrateMonomer
extends Monomer {
    private static final byte[] alphaOffsets = new byte[]{0};

    private CarbohydrateMonomer() {
    }

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex) {
        return new CarbohydrateMonomer().set2(chain, group3, seqcode, firstIndex, lastIndex, alphaOffsets);
    }

    public boolean isCarbohydrate() {
        return true;
    }

    @Override
    public STR getProteinStructureType() {
        return STR.CARBOHYDRATE;
    }

    @Override
    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            for (int j = possiblyPreviousMonomer.firstAtomIndex; j <= possiblyPreviousMonomer.lastAtomIndex; ++j) {
                Atom a = this.chain.model.ms.at[i];
                Atom b = this.chain.model.ms.at[j];
                if (a.getElementNumber() + b.getElementNumber() != 14 || !((double)a.distanceSquared((T3)b) < 3.24)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void findNearestAtomIndex(int x, int y, Atom[] closest, short madBegin, short madEnd) {
        Atom competitor = closest[0];
        Atom anomericO = this.getLeadAtom();
        int marBegin = madBegin / 2;
        if (marBegin < 1200) {
            marBegin = 1200;
        }
        if (anomericO.sZ == 0) {
            return;
        }
        int radiusBegin = (int)this.scaleToScreen(anomericO.sZ, marBegin);
        if (radiusBegin < 4) {
            radiusBegin = 4;
        }
        if (this.isCursorOnTopOf(anomericO, x, y, radiusBegin, competitor)) {
            closest[0] = anomericO;
        }
    }

    @Override
    public boolean isConnectedPrevious() {
        if (this.monomerIndex <= 0) {
            return false;
        }
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!this.getCrossLinkGroup(i, null, null, true, false, false)) continue;
            return true;
        }
        return false;
    }
}

